/*
 * Decompiled with CFR 0.152.
 */
package com.ageofelysian.ageofperformance;

import com.ageofelysian.ageofperformance.SimpleSkullType;
import com.ageofelysian.ageofperformance.block.SimpleSkullBlock;
import com.ageofelysian.ageofperformance.block.SimpleWallSkullBlock;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2484;
import net.minecraft.class_2549;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_9296;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgeOfPerformance
implements ModInitializer {
    public static final String MOD_ID = "age-of-performance";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"age-of-performance");
    private static final Map<String, SimpleSkullType> TEXTURE_TO_TYPE = new ConcurrentHashMap<String, SimpleSkullType>();

    public void onInitialize() {
        SimpleSkullBlock.initialize();
        SimpleWallSkullBlock.initialize();
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            for (class_2586 blockEntity : new ArrayList(chunk.method_12214().values())) {
                this.handleBlockEntity(world, blockEntity);
            }
        });
    }

    private void handleBlockEntity(class_638 world, class_2586 blockEntity) {
        class_642 serverInfo = class_310.method_1551().method_1558();
        if (serverInfo == null || !serverInfo.field_3761.toLowerCase().endsWith(".ageofelysian.com")) {
            return;
        }
        if (blockEntity instanceof class_2631) {
            class_2631 skullBlockEntity = (class_2631)blockEntity;
            class_9296 owner = skullBlockEntity.method_11334();
            if (owner == null) {
                world.method_8544(skullBlockEntity.method_11016());
                return;
            }
            GameProfile gameProfile = owner.method_73313();
            if (gameProfile == null) {
                return;
            }
            ArrayList textures = new ArrayList(gameProfile.properties().get((Object)"textures"));
            if (textures.isEmpty()) {
                return;
            }
            String texture = ((Property)textures.getFirst()).value();
            SimpleSkullType type = AgeOfPerformance.getTypeByTexture(texture);
            if (type == null) {
                return;
            }
            AgeOfPerformance.update(blockEntity.method_11016(), blockEntity.method_11010(), type);
        }
    }

    public static void update(class_2338 pos, class_2680 blockState, SimpleSkullType type) {
        class_638 world = class_310.method_1551().field_1687;
        if (blockState.method_26204() == class_2246.field_10432) {
            world.method_8544(pos);
            world.method_8501(pos, (class_2680)((class_2680)SimpleSkullBlock.SIMPLE_SKULL.method_9564().method_11657(SimpleSkullBlock.TYPE, (Comparable)((Object)type))).method_11657((class_2769)class_2484.field_11505, (Comparable)((Integer)blockState.method_11654((class_2769)class_2484.field_11505))));
        } else if (blockState.method_26204() == class_2246.field_10208) {
            world.method_8544(pos);
            world.method_8501(pos, (class_2680)((class_2680)SimpleWallSkullBlock.SIMPLE_WALL_SKULL.method_9564().method_11657(SimpleSkullBlock.TYPE, (Comparable)((Object)type))).method_11657((class_2769)class_2549.field_11724, (Comparable)((class_2350)blockState.method_11654((class_2769)class_2549.field_11724))));
        }
    }

    public static class_2680 convertSkullToVanilla(class_2680 simpleSkull) {
        if (simpleSkull.method_26204() == SimpleSkullBlock.SIMPLE_SKULL) {
            return (class_2680)class_2246.field_10432.method_9564().method_11657((class_2769)class_2484.field_11505, (Comparable)((Integer)simpleSkull.method_11654((class_2769)class_2484.field_11505)));
        }
        if (simpleSkull.method_26204() == SimpleWallSkullBlock.SIMPLE_WALL_SKULL) {
            return (class_2680)class_2246.field_10208.method_9564().method_11657((class_2769)class_2549.field_11724, (Comparable)((class_2350)simpleSkull.method_11654((class_2769)class_2549.field_11724)));
        }
        return null;
    }

    public static class_2680 convertSkull(class_2680 simpleSkull, class_2680 vanillaSkull) {
        if (vanillaSkull.method_26204() == class_2246.field_10432) {
            if (simpleSkull.method_26204() == SimpleSkullBlock.SIMPLE_SKULL) {
                return (class_2680)simpleSkull.method_11657((class_2769)class_2484.field_11505, (Comparable)((Integer)vanillaSkull.method_11654((class_2769)class_2484.field_11505)));
            }
            if (simpleSkull.method_26204() == SimpleWallSkullBlock.SIMPLE_WALL_SKULL) {
                return (class_2680)((class_2680)SimpleSkullBlock.SIMPLE_SKULL.method_9564().method_11657((class_2769)class_2484.field_11505, (Comparable)((Integer)vanillaSkull.method_11654((class_2769)class_2484.field_11505)))).method_11657(SimpleSkullBlock.TYPE, (Comparable)((Object)((SimpleSkullType)((Object)simpleSkull.method_11654(SimpleSkullBlock.TYPE)))));
            }
        } else if (vanillaSkull.method_26204() == class_2246.field_10208) {
            if (simpleSkull.method_26204() == SimpleWallSkullBlock.SIMPLE_WALL_SKULL) {
                return (class_2680)simpleSkull.method_11657((class_2769)class_2549.field_11724, (Comparable)((class_2350)vanillaSkull.method_11654((class_2769)class_2549.field_11724)));
            }
            if (simpleSkull.method_26204() == SimpleSkullBlock.SIMPLE_SKULL) {
                return (class_2680)((class_2680)SimpleWallSkullBlock.SIMPLE_WALL_SKULL.method_9564().method_11657((class_2769)class_2549.field_11724, (Comparable)((class_2350)vanillaSkull.method_11654((class_2769)class_2549.field_11724)))).method_11657(SimpleSkullBlock.TYPE, (Comparable)((Object)((SimpleSkullType)((Object)simpleSkull.method_11654(SimpleSkullBlock.TYPE)))));
            }
        }
        return null;
    }

    public static SimpleSkullType getTypeByTexture(String texture) {
        return TEXTURE_TO_TYPE.get(texture);
    }

    static {
        for (SimpleSkullType type : SimpleSkullType.values()) {
            TEXTURE_TO_TYPE.put(type.getTexture(), type);
        }
    }
}

